﻿param (
    [Parameter(Mandatory=$true)][string]$samaccountname,
    [Parameter(Mandatory=$true)][string]$ou
)

# kijken of we de samaccountname in de opgegeven OU kunnen vinden
$founduser = Get-ADUser -Filter 'SamAccountName -like $samaccountname' -SearchBase $ou

if($founduser -eq $Null){
    Write-Host "Gebruiker niet gevonden"
}
else{
    try{
        Remove-ADUser $samaccountname -Confirm:$false
    }
    catch{
        Write-Host "Fout bij het verwijderen van de gebruiker"
    }
 
}
